<?php

namespace App\Entities\Tally\Management;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Team extends Model 
{

    protected $table = 'teams';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $guarded = array('user_id', 'project_id');

    public function periods()
    {
        return $this->hasMany('App\Entities\Tally\Management\Period', 'period_ids');
    }

}